# optimize-bundle-size

Analyze and reduce JavaScript bundle size

## Usage

Run this command to analyze and optimize performance.

## Process

1. Analyze current performance metrics
2. Identify bottlenecks and issues
3. Apply optimizations
4. Verify improvements
5. Document changes

## Commands

```bash
# Analyze bundle size
npx webpack-bundle-analyzer

# Run lighthouse audit
npx lighthouse http://localhost:3000

# Profile memory usage
node --inspect app.js
```

## Metrics

| Metric      | Target  |
| ----------- | ------- |
| LCP         | < 2.5s  |
| FID         | < 100ms |
| CLS         | < 0.1   |
| Bundle Size | < 200KB |

## Output

- Performance audit report
- Optimization recommendations
- Before/after metrics
- Configuration changes
